#include <cstdio>
#include <numeric>
#include <cstring>

const int N = 1000000;
const int A = 5;
int n, m;
char s[N + 1];

void mul(int *p, int *q) {
	for (int i = 0; i < A; ++i) p[i] = q[p[i]];
}

struct item {
	int a[A], p[A];
	item() {
		memset(a, 0, sizeof a);
		std::iota(p, p + A, 0);
	}
	void push(int v, int tl, int tr);
} t[N * 2];

void item::push(int v, int tl, int tr) {
	int next[A];
	memset(next, 0, sizeof next);
	for (int i = 0; i < A; ++i) next[p[i]] += a[i];
	memcpy(a, next, sizeof next);
	if (tr - tl > 1) {
		mul(t[v + 1].p, p);
		mul(t[v + (tr - tl & ~1)].p, p);
	}
	std::iota(p, p + A, 0);
}

item operator+(item a, item b) {
	item res;
	for (int i = 0; i < A; ++i) res.a[i] = a.a[i] + b.a[i];
	return res;
}

void build(int v = 0, int tl = 0, int tr = n) {
	if (tr - tl == 1) ++t[v].a[s[tl] - 'a'];
	else {
		int m = tl + tr >> 1;
		build(v + 1, tl, m);
		build(v + (tr - tl & ~1), m, tr);
		t[v] = t[v + 1] + t[v + (tr - tl & ~1)];
	}
}

int update(int types, int typet, int cnt, int v = 0, int tl = 0, int tr = n) {
	t[v].push(v, tl, tr);
	if (cnt <= 0) return 0;
	if (t[v].a[types] <= cnt) {
		cnt -= t[v].a[types];
		t[v].p[types] = typet;
		t[v].push(v, tl, tr);
		return cnt;
	}
	int m = tl + tr >> 1;
	cnt = update(types, typet, cnt, v + 1, tl, m);
	cnt = update(types, typet, cnt, v + (tr - tl & ~1), m, tr);
	t[v] = t[v + 1] + t[v + (tr - tl & ~1)];
	return cnt;
}

void dfs(int v = 0, int tl = 0, int tr = n) {
	t[v].push(v, tl, tr);
	if (tr - tl == 1) {
		int j;
		for (j = 0; !t[v].a[j]; ++j);
		s[tl] = 'a' + j;
	} else {
		int m = tl + tr >> 1;
		dfs(v + 1, tl, m);
		dfs(v + (tr - tl & ~1), m, tr);
	}
}

int main() {
	scanf("%d%d%s", &n, &m, s);
	build();
	for (int i = 0; i < m; ++i) {
		int x;
		char a, b;
		scanf("%d %c %c", &x, &a, &b);
		update(a - 'a', b - 'a', x);
	}
	dfs();
	printf("%s\n", s);
	return 0;
}
